#ifndef INCLUDE_CAVE_FACTOR
#define INCLUDE_CAVE_FACTOR
    #define CAVE_FOG_R 33.15 //[0.0 4.0 8.0 12.0 16.0 20.0 24.0 28.0 32.0 33.15 36.0 40.0 44.0 48.0 52.0 56.0 60.0 64.0 68.0 72.0 76.0 80.0 84.0 88.0 92.0 96.0 100.0 104.0 108.0 112.0 116.0 120.0 124.0 128.0 132.0 136.0 140.0 144.0 148.0 152.0 156.0 160.0 164.0 168.0 172.0 176.0 180.0 184.0 188.0 192.0 196.0 200.0 204.0 208.0 212.0 216.0 220.0 224.0 228.0 232.0 236.0 240.0 244.0 248.0 252.0 255.0]
    #define CAVE_FOG_G 33.15 //[0.0 4.0 8.0 12.0 16.0 20.0 24.0 28.0 32.0 33.15 36.0 40.0 44.0 48.0 52.0 56.0 60.0 64.0 68.0 72.0 76.0 80.0 84.0 88.0 92.0 96.0 100.0 104.0 108.0 112.0 116.0 120.0 124.0 128.0 132.0 136.0 140.0 144.0 148.0 152.0 156.0 160.0 164.0 168.0 172.0 176.0 180.0 184.0 188.0 192.0 196.0 200.0 204.0 208.0 212.0 216.0 220.0 224.0 228.0 232.0 236.0 240.0 244.0 248.0 252.0 255.0]
    #define CAVE_FOG_B 38.25 //[0.0 4.0 8.0 12.0 16.0 20.0 24.0 28.0 32.0 36.0 38.25 40.0 44.0 48.0 52.0 56.0 60.0 64.0 68.0 72.0 76.0 80.0 84.0 88.0 92.0 96.0 100.0 104.0 108.0 112.0 116.0 120.0 124.0 128.0 132.0 136.0 140.0 144.0 148.0 152.0 156.0 160.0 164.0 168.0 172.0 176.0 180.0 184.0 188.0 192.0 196.0 200.0 204.0 208.0 212.0 216.0 220.0 224.0 228.0 232.0 236.0 240.0 244.0 248.0 252.0 255.0]
    #define CAVE_FOG_I 1.00 //[0.20 0.25 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.0]

    float GetCaveFactor() {
        return clamp(1.0 - cameraPosition.y / oceanAltitude, 0.0, 1.0 - eyeBrightnessM);
    }

    vec3 caveFogColorRaw = vec3(CAVE_FOG_R, CAVE_FOG_G, CAVE_FOG_B) / 255 * CAVE_FOG_I;
    #if CAVE_LIGHTING < 100
        vec3 caveFogColor = caveFogColorRaw * 0.7;
    #elif CAVE_LIGHTING == 100
        vec3 caveFogColor = caveFogColorRaw * (0.7 + 0.3 * vsBrightness); // Default
    #elif CAVE_LIGHTING > 100
        vec3 caveFogColor = caveFogColorRaw;
    #endif
#endif
